# Assessment Specification

## Problem: Add Two Numbers

**Difficulty:** Easy
**Time Limit:** 2 hours
**Question ID:** SAMPLE001
**Total Test Cases:** 5
**Points:** 100

---

## Problem Statement

Write a function `add(a, b)` that takes two numbers as input and returns their sum.

Your solution should be implemented in the `solution.py` file. The function signature is already provided for you.

---

## Function Signature

```python
def add(a: int, b: int) -> int:
    """
    Add two numbers and return their sum.

    Args:
        a (int): First number
        b (int): Second number

    Returns:
        int: Sum of a and b
    """
    pass
```

---

## Examples

### Example 1
```
Input: a = 2, b = 3
Output: 5
Explanation: 2 + 3 = 5
```

### Example 2
```
Input: a = -1, b = 1
Output: 0
Explanation: -1 + 1 = 0
```

### Example 3
```
Input: a = 0, b = 0
Output: 0
Explanation: 0 + 0 = 0
```

### Example 4
```
Input: a = 100, b = 200
Output: 300
Explanation: 100 + 200 = 300
```

---

## Constraints

- `-1000 ≤ a, b ≤ 1000`
- Both `a` and `b` are integers

---

## Instructions

### Step 1: Implement Your Solution
1. Open `solution.py` in your preferred editor
2. Implement the `add()` function
3. Save your changes

### Step 2: Run Tests Locally
```bash
# Run the test suite
python test_solution.py

# Or use the provided script
bash run_tests.sh
```

### Step 3: Check Results
- After running tests, check `test_report.log` for results
- The log will show:
  - `[PASS]` for passing test cases
  - `[FAIL]` for failing test cases
  - Detailed error messages for failures

### Step 4: Submit Your Solution
- Once all tests pass, click **"Submit Solution"** in the app
- Your submission will be uploaded and graded automatically

---

## Test Cases Overview

Your solution will be evaluated against 5 test cases:

1. **TC_001**: Basic addition (positive numbers)
2. **TC_002**: Addition with negative numbers
3. **TC_003**: Addition with zero
4. **TC_004**: Large positive numbers
5. **TC_005**: Large negative numbers

---

## Scoring

- Each test case is worth **20 points**
- Total score = (Passed Test Cases / Total Test Cases) × 100
- You need to pass **all test cases** to get full marks

---

## Files in This Workspace

- `solution.py` - Your implementation file (EDIT THIS)
- `test_solution.py` - Test suite (DO NOT EDIT)
- `run_tests.sh` - Script to run tests and generate report
- `solution_SAMPLE.py` - Sample solution for reference
- `specification.md` - This file
- `README.md` - Quick reference guide

---

## Tips for Success

1. **Read the problem carefully** - Make sure you understand the requirements
2. **Test incrementally** - Run tests after each change
3. **Check edge cases** - Consider zero, negative numbers, and boundary values
4. **Read error messages** - They provide hints about what went wrong
5. **Time management** - You have 2 hours from when you download the question

---

## Need Help?

- Check `solution_SAMPLE.py` for a working reference implementation
- Review the test cases in `test_solution.py` to understand expectations
- Make sure your function signature matches exactly

---

## Submission Guidelines

✅ **DO:**
- Implement only the `add()` function
- Test your code thoroughly before submitting
- Keep your code clean and readable

❌ **DON'T:**
- Modify test files
- Change function signatures
- Import unauthorized libraries
- Use external resources during the assessment

---

Good luck! 🚀
